<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    class VisualizzatorePortfolio extends VisualizzatoreComponente {
        
        private $tutteLeCategorie;
        private $aspectRatio;
        private $impostazioniAspetto;
        
        function __construct($db) {
            parent::__construct($db);
            $this->tutteLeCategorie = ".nessunaCategoria, "; // questo spazio non va rimosso
            $this->aspectRatio = "";
            $this->impostazioniAspetto = parent::getDb()->leggiSingolaRiga("geecB_impostazioni",1);
        }
        
        function generaContenutoSezione($dati) {
            $portfolio = parent::getDb()->leggiSingolaRiga("geec_portfolio",$dati["idElemento"]);
            
            if($portfolio["aspetto"]=="classico") {
            	$this->stampaPortfolioAspettoClassico($dati,$portfolio);
            }
            else {
		$this->stampaPortfolioAspettoElenco($dati,$portfolio);
            }
        }
        
        function stampaPortfolioAspettoClassico($dati,$portfolio) {
            $this->aspectRatio = $portfolio["aspectRatio"];
            
            echo"<div class=\"{$portfolio["spazioOccupato"]}\">
                        <div class=\"row\">
                            <div class=\"col-md-12 mb-3 text-center\">
                                <h2 class=\"separatore-inferiore\">{$portfolio["nome"]}</h2>
                                <p class=\"lead\">{$portfolio["descrizione"]}</p>
                            </div>
                            <div class=\"portfolioWrapper col\">";

            $query="SELECT * FROM geec_categorie WHERE tipo LIKE 'categoriaPortfolio' AND categoriaMadre = {$dati["idElemento"]}";
            $risCategoria = parent::getDb()->eseguiQueryLettura($query);
            
            /*
             * Questo codice è necesario per fare in modo che il portfolio mostri gli elementi di
             * ogni categoria: viene creata una lista di elementi con tanti tag <li> per ogni categoria
             * Ogni tag <li> contiene un tag span dove nel campo data-filter viene inserita
             * la categoria
             * 
             * Il primo campo di questa lista è quello che contiene tutte le categorie, quindi
             * viene creato per ultimo perché bisogna scorrere tutte le categorie che la query
             * ha restituito. Nel ciclo while qui sotto vengono creati gli elementi e messi in un
             * array e contemporaneamente viene aggiornata la variabile di classe @tutteLeCategorie
             * che viene messa come data-filter nel campo "Tutto"
             */
            $arrayFiltri = array();
            while($categoria=$risCategoria->fetch_assoc()) {
                $idCategoria = str_replace(" ", "", $categoria["nome"]);
                $arrayFiltri[count($arrayFiltri)] = "<li><span class=\"filter\" data-filter=\".$idCategoria\">{$categoria["nome"]}</span></li>";
                $this->tutteLeCategorie .= ".$idCategoria, ";
            }

            $this->tutteLeCategorie = substr($this->tutteLeCategorie, 0, strlen($this->tutteLeCategorie)-2);
            /*
             * Se il portfolio è di tipo filtrabile viene mostrato il menu
             */ 
            if($risCategoria->num_rows>0 && $portfolio["filtrabile"]=="si") {
                echo"<ul class=\"filters clearfix\">
                    <li><span class=\"filter active\" data-filter=\"$this->tutteLeCategorie\">Tutto</span></li>";
                    foreach($arrayFiltri as $filtro) {
                        echo $filtro;
                    }
                echo"</ul>";
            }
            else { // altrimenti viene creato lo stesso (solo la voce principale) ma non viene mostrato
                echo"<ul class=\"filters \" style=\"display: none\">
                    <li><span class=\"filter active\" data-filter=\"$this->tutteLeCategorie\">Tutto</span></li>";
                echo"</ul>";
            }
            
            //creazione elementi portfolio
            $querySlide="SELECT * FROM geecB_contenuti WHERE tipo LIKE 'elementoPortfolio' AND contenutoRiferimento={$dati["idElemento"]} AND stato LIKE 'pubblicato' ORDER BY posizione ASC";
            $risElementi = parent::getDb()->eseguiQueryLettura($querySlide);
            
            if($risElementi->num_rows==0) {
                echo"<h2>Attenzione, non sono presenti elementi in questo portfolio. Crearli dal pannello amministrativo</h2>";
            }
            
            if($portfolio["senzaBordi"]=="si") {
                echo"<div class=\"portfoliolist row no-gutters\">";
            }
            else {
                echo"<div class=\"portfoliolist row\">";
            }
            while($elemento=$risElementi->fetch_assoc()) {
                $categoria   = $this->getDb()->leggiSingolaRiga("geec_categorie",$elemento["categoria"]);
                $idCategoria = isset($categoria["nome"]) ? str_replace(" ", "", $categoria["nome"]) : "nessunaCategoria";
                
                $classeBase = ($portfolio["mostraNomiElementi"]=="si") ? $portfolio["classeElementi"]." labelVisibile" : $portfolio["classeElementi"];
                $this->stampaElementoConLink($elemento,$classeBase,$categoria,$idCategoria);
                
            }
            echo"</div>";
            
            //chiudo il div carousel inner, creo le frecce e chiudo il div principale dello slider
                echo"</div>"
                . "</div>"
              . "</div>";
        
        }
        
        function stampaPortfolioAspettoElenco($dati,$portfolio) {
            //creazione elementi portfolio
            $querySlide="SELECT * FROM geecB_contenuti WHERE tipo LIKE 'elementoPortfolio' AND contenutoRiferimento={$dati["idElemento"]} ORDER BY posizione ASC";
            $risElementi = parent::getDb()->eseguiQueryLettura($querySlide);
            
            if($risElementi->num_rows==0) {
                echo"<h2>Attenzione, non sono presenti elementi in questo portfolio. Crearli dal pannello amministrativo</h2>";
            }
            else {
            	?>
            	<div class="<?= $portfolio["spazioOccupato"] ?>">
                    <div class="row">
                            <div class="col-md-12 mb-3 text-center">
                                <h2 class="separatore-inferiore"><?= $portfolio["nome"] ?></h2>
                                <p class="lead"><?= $portfolio["descrizione"] ?></p>
                            </div>
                            <?php
				    while($elemento=$risElementi->fetch_assoc()) {
					$categoria   = $this->getDb()->leggiSingolaRiga("geec_categorie",$elemento["categoria"]);
					
					$this->stampaElementoElenco($elemento,$portfolio["classeElementi"]);
				    }
			    ?>	
                    </div>
            	</div>
            	<?php
            }
        }
        
        function stampaElementoConLink($elemento,$classeBase,$categoria,$idCategoria) {
            if($elemento["abilitaCommenti"]=="si") {
                $linkElemento = $elemento["alias"];
            }
            else {            
                $linkElemento = GeneratoreUrl::creaUrlContenuto($elemento, $this->impostazioniAspetto["ottimizzazioneUrl"], $this->impostazioniAspetto["urlSito"]);
            }
            echo"<div class=\"$classeBase $idCategoria\" data-cat=\"$idCategoria\">
            <div class=\"portfolio-wrapper mb-4\">
                <a href=\"$linkElemento\">
                    <div class=\"background-image $this->aspectRatio\" style=\"background: url('{$elemento["foto"]}')\"></div>
                    <div class=\"label\">
                        <div class=\"label-text\">
                            <div class=\"text-title\">{$elemento["titolo"]}</div>";
                            if($idCategoria!="nessunaCategoria") {
                               echo"<span class=\"text-category\">{$categoria["nome"]}</span>";
                            }
                        echo"</div>
                        <div class=\"label-bg\"></div>
                    </div>
                </a>
            </div></div>";
        }

        function stampaElementoElenco($elemento,$classeBase) {
            if($elemento["abilitaCommenti"]=="si") {
                $linkElemento = $elemento["alias"];
            }
            else {            
                $linkElemento = GeneratoreUrl::creaUrlContenuto($elemento, $this->impostazioniAspetto["ottimizzazioneUrl"], $this->impostazioniAspetto["urlSito"]);
            }
            ?>
            <div class="<?= $classeBase ?>">
	        <a href="<?= $linkElemento ?>">
	        	<h3><?= $elemento["titolo"] ?></h3>
	        </a>
            </div>
            <?php
        }        
        
        function getJavascriptAssociato() {
            return "<script>
                $(function () {	
                    var filterList = {
                        init: function () {
                            $('.portfoliolist').mixItUp({
                            selectors: {
                                target: '.portfolio',
                                filter: '.filter'	
                            },
                            load: {
                                  filter: '$this->tutteLeCategorie'  
                                }
                            });								
                        }
                    };
                    filterList.init();
                });
            </script>";
        }

    }